#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef DROID_SANS_12_H
#define DROID_SANS_12_H

#define DROID_SANS_12_WIDTH 10
#define DROID_SANS_12_HEIGHT 12

static const uint8_t Droid_Sans_12[] PROGMEM = {
    0x15, 0xBA, // size
    0x0A, // width
    0x0C, // height
    0x20, // first char
    0x60, // char count
    
    // char widths
    0x00, 0x01, 0x03, 0x08, 0x05, 0x09, 0x07, 0x01, 0x03, 0x03, 
    0x05, 0x05, 0x02, 0x03, 0x01, 0x04, 0x05, 0x03, 0x05, 0x05, 
    0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x02, 0x05, 0x05, 
    0x05, 0x04, 0x08, 0x07, 0x05, 0x06, 0x06, 0x04, 0x05, 0x06, 
    0x06, 0x03, 0x02, 0x06, 0x05, 0x09, 0x07, 0x07, 0x05, 0x07, 
    0x05, 0x05, 0x07, 0x06, 0x07, 0x0B, 0x07, 0x07, 0x05, 0x03, 
    0x04, 0x03, 0x06, 0x05, 0x02, 0x05, 0x05, 0x04, 0x05, 0x05, 
    0x03, 0x05, 0x05, 0x01, 0x02, 0x05, 0x01, 0x09, 0x05, 0x05, 
    0x05, 0x05, 0x03, 0x04, 0x04, 0x05, 0x05, 0x09, 0x04, 0x05, 
    0x04, 0x04, 0x01, 0x04, 0x05, 0x05, 
    
    // font data
    0xBF, 0x10, // 33
    0x07, 0x00, 0x07, 0x00, 0x00, 0x00, // 34
    0x24, 0xE4, 0x3E, 0x25, 0xA4, 0x7C, 0x27, 0x24, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, // 35
    0x0C, 0x12, 0xFF, 0x22, 0xE2, 0x10, 0x10, 0x30, 0x10, 0x00, // 36
    0x0E, 0x11, 0x91, 0x6E, 0x10, 0xEC, 0x13, 0x10, 0xE0, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00, // 37
    0xE0, 0x1E, 0x19, 0x29, 0xC6, 0xC0, 0x20, 0x00, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, // 38
    0x07, 0x00, // 39
    0xFC, 0x06, 0x01, 0x10, 0x30, 0x40, // 40
    0x01, 0x06, 0xFC, 0x40, 0x30, 0x10, // 41
    0x04, 0x1C, 0x07, 0x1C, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, // 42
    0x10, 0x10, 0x7C, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, // 43
    0x00, 0x00, 0x60, 0x30, // 44
    0x20, 0x20, 0x20, 0x00, 0x00, 0x00, // 45
    0x80, 0x10, // 46
    0x80, 0x70, 0x0C, 0x03, 0x10, 0x00, 0x00, 0x00, // 47
    0xFE, 0x83, 0x01, 0x83, 0xFE, 0x00, 0x10, 0x10, 0x10, 0x00, // 48
    0x02, 0x01, 0xFF, 0x00, 0x00, 0x10, // 49
    0x02, 0xC1, 0x61, 0x31, 0x0E, 0x10, 0x10, 0x10, 0x10, 0x10, // 50
    0x02, 0x11, 0x11, 0x19, 0xEE, 0x10, 0x10, 0x10, 0x10, 0x00, // 51
    0x60, 0x50, 0x4C, 0x42, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, // 52
    0x0F, 0x09, 0x09, 0x09, 0xF0, 0x10, 0x10, 0x10, 0x10, 0x00, // 53
    0xFC, 0x8A, 0x09, 0x09, 0xF0, 0x00, 0x10, 0x10, 0x10, 0x00, // 54
    0x01, 0x81, 0x61, 0x1D, 0x03, 0x00, 0x10, 0x00, 0x00, 0x00, // 55
    0xEE, 0x19, 0x11, 0x39, 0xEE, 0x00, 0x10, 0x10, 0x10, 0x00, // 56
    0x1E, 0x21, 0x21, 0xA3, 0x7E, 0x00, 0x10, 0x10, 0x00, 0x00, // 57
    0x98, 0x10, // 58
    0x00, 0x18, 0x60, 0x30, // 59
    0x10, 0x28, 0x28, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, // 60
    0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, // 61
    0x44, 0x28, 0x28, 0x28, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, // 62
    0x01, 0xB1, 0x19, 0x0E, 0x00, 0x10, 0x00, 0x00, // 63
    0xF8, 0x06, 0x79, 0x85, 0x85, 0xFD, 0x82, 0x7C, 0x00, 0x10, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, // 64
    0x80, 0x70, 0x2E, 0x21, 0x2E, 0x70, 0x80, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, // 65
    0xFF, 0x11, 0x11, 0x11, 0xEE, 0x10, 0x10, 0x10, 0x10, 0x00, // 66
    0x7C, 0x86, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, // 67
    0xFF, 0x01, 0x01, 0x01, 0x82, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, // 68
    0xFF, 0x11, 0x11, 0x11, 0x10, 0x10, 0x10, 0x10, // 69
    0xFF, 0x11, 0x11, 0x11, 0x11, 0x10, 0x00, 0x00, 0x00, 0x00, // 70
    0x7C, 0x82, 0x01, 0x11, 0x11, 0xF1, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, // 71
    0xFF, 0x10, 0x10, 0x10, 0x10, 0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, // 72
    0x01, 0xFF, 0x01, 0x10, 0x10, 0x10, // 73
    0x00, 0xFF, 0x40, 0x30, // 74
    0xFF, 0x10, 0x18, 0x64, 0xC2, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, // 75
    0xFF, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, // 76
    0xFF, 0x03, 0x1C, 0xE0, 0x80, 0x60, 0x1C, 0x03, 0xFF, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, // 77
    0xFF, 0x03, 0x0C, 0x10, 0x60, 0x80, 0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, // 78
    0x7C, 0x82, 0x01, 0x01, 0x01, 0x82, 0x7C, 0x00, 0x00, 0x10, 0x10, 0x10, 0x00, 0x00, // 79
    0xFF, 0x21, 0x21, 0x33, 0x1E, 0x10, 0x00, 0x00, 0x00, 0x00, // 80
    0x7C, 0x82, 0x01, 0x01, 0x01, 0x82, 0x7C, 0x00, 0x00, 0x10, 0x10, 0x30, 0x60, 0x00, // 81
    0xFF, 0x11, 0x11, 0xF1, 0x8E, 0x10, 0x00, 0x00, 0x00, 0x10, // 82
    0x0E, 0x19, 0x11, 0x31, 0xE1, 0x10, 0x10, 0x10, 0x10, 0x00, // 83
    0x01, 0x01, 0x01, 0xFF, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, // 84
    0xFF, 0x80, 0x00, 0x00, 0x80, 0xFF, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, // 85
    0x03, 0x1C, 0xE0, 0x00, 0xE0, 0x1C, 0x03, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, // 86
    0x07, 0xF8, 0x00, 0xF0, 0x0E, 0x01, 0x0E, 0xF0, 0x00, 0xF8, 0x07, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, // 87
    0x01, 0xC2, 0x6C, 0x18, 0x6C, 0xC2, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, // 88
    0x01, 0x06, 0x18, 0xE0, 0x18, 0x06, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, // 89
    0x81, 0xE1, 0x39, 0x0F, 0x03, 0x10, 0x10, 0x10, 0x10, 0x10, // 90
    0xFF, 0x01, 0x01, 0x70, 0x40, 0x40, // 91
    0x03, 0x1C, 0x60, 0x80, 0x00, 0x00, 0x00, 0x10, // 92
    0x01, 0x01, 0xFF, 0x40, 0x40, 0x70, // 93
    0x10, 0x0C, 0x03, 0x03, 0x0C, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 94
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, // 95
    0x01, 0x02, 0x00, 0x00, // 96
    0xC8, 0x28, 0x28, 0x28, 0xF0, 0x00, 0x10, 0x10, 0x10, 0x10, // 97
    0xFF, 0x08, 0x08, 0x08, 0xF0, 0x10, 0x10, 0x10, 0x10, 0x00, // 98
    0xF0, 0x08, 0x08, 0x08, 0x00, 0x10, 0x10, 0x10, // 99
    0xF0, 0x08, 0x08, 0x08, 0xFF, 0x00, 0x10, 0x10, 0x10, 0x10, // 100
    0xF0, 0x28, 0x28, 0x28, 0x30, 0x00, 0x10, 0x10, 0x10, 0x10, // 101
    0x08, 0xFF, 0x09, 0x00, 0x10, 0x00, // 102
    0x30, 0xC8, 0x48, 0x38, 0x08, 0x60, 0x90, 0x90, 0x90, 0x70, // 103
    0xFF, 0x08, 0x08, 0x08, 0xF0, 0x10, 0x00, 0x00, 0x00, 0x10, // 104
    0xFA, 0x10, // 105
    0x00, 0xFA, 0x80, 0xF0, // 106
    0xFF, 0x20, 0x70, 0x98, 0x08, 0x10, 0x00, 0x00, 0x00, 0x10, // 107
    0xFF, 0x10, // 108
    0xF8, 0x08, 0x08, 0x08, 0xF0, 0x08, 0x08, 0x08, 0xF0, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, // 109
    0xF8, 0x08, 0x08, 0x08, 0xF0, 0x10, 0x00, 0x00, 0x00, 0x10, // 110
    0xF0, 0x08, 0x08, 0x08, 0xF0, 0x00, 0x10, 0x10, 0x10, 0x00, // 111
    0xF8, 0x08, 0x08, 0x08, 0xF0, 0xF0, 0x10, 0x10, 0x10, 0x00, // 112
    0xF0, 0x08, 0x08, 0x08, 0xF8, 0x00, 0x10, 0x10, 0x10, 0xF0, // 113
    0xF8, 0x08, 0x08, 0x10, 0x00, 0x00, // 114
    0x38, 0x28, 0x48, 0xC8, 0x10, 0x10, 0x10, 0x00, // 115
    0x08, 0xFC, 0x08, 0x08, 0x00, 0x10, 0x10, 0x10, // 116
    0xF8, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x10, 0x10, 0x10, 0x10, // 117
    0x18, 0xE0, 0x00, 0xE0, 0x18, 0x00, 0x00, 0x10, 0x00, 0x00, // 118
    0x18, 0xE0, 0x00, 0xF0, 0x08, 0xF0, 0x00, 0xE0, 0x18, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, // 119
    0x98, 0xF0, 0xF0, 0x98, 0x10, 0x00, 0x00, 0x10, // 120
    0x18, 0xE0, 0x00, 0xE0, 0x18, 0x80, 0x80, 0x70, 0x00, 0x00, // 121
    0x88, 0xC8, 0x28, 0x18, 0x10, 0x10, 0x10, 0x10, // 122
    0x20, 0x20, 0xDF, 0x01, 0x00, 0x00, 0x70, 0x40, // 123
    0xFF, 0xF0, // 124
    0x01, 0xDF, 0x20, 0x20, 0x40, 0x70, 0x00, 0x00, // 125
    0x08, 0x08, 0x18, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, // 126
    0xFF, 0x01, 0x01, 0x01, 0xFF, 0x10, 0x10, 0x10, 0x10, 0x10 // 127
    
};

#endif
